//
//  ZScanner.h
//  sEdit
//
//  Created by 増田 勇樹 on 04/08/20.
//  Copyright 2004 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

@class ZScannerMatch;

@interface ZScanner : NSObject
{	
	NSMutableArray *_identifiers;
	NSMutableArray *_regexes;
	
	struct re_pattern_buffer *_regex;
	
	BOOL _needsRecompile;
}

+ (ZScanner *)scanner;

- (void)addRuleWithIdentifier:(id)identifier regularExpression:(NSString *)regex;
- (void)removeRuleWithIdentifier:(id)identifier;

- (ZScannerMatch *)matchInString:(NSString *)string range:(NSRange)range;
- (ZScannerMatch *)matchInCharacters:(unichar *)characters length:(unsigned int)length range:(NSRange)range;

- (NSEnumerator *)scanEnumeratorInString:(NSString *)string;
- (NSEnumerator *)scanEnumeratorInString:(NSString *)string range:(NSRange)range;

- (NSString *)description;
@end