//
//  DRFileNotificationSubscription.h
//  MoreWaysToSkinADock
//
//  Created by David Remahl on Fri Apr 12 2002.
//  Copyright (c) 2001 Infinity-to-the-Power-of-Infinity. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <Carbon/Carbon.h>


@interface DRFileNotificationSubscription : NSObject
{
	NSString *watchedPath;
    id target;
    SEL action;
    FNSubscriptionRef subRef;
    FNSubscriptionUPP subUPP;
}

- (id)initForDirectory:(NSString*)path target:(id)newTarget action:(SEL)action;

- (void)setTarget:(id)newTarget;
- (void)setAction:(SEL)newAction;

- (id)target;
- (SEL)action;

- (NSString *)watchedPath;

- (void)fire;

@end

void DRFileSubscriptionProc(FNMessage message, OptionBits flags, DRFileNotificationSubscription* refcon, FNSubscriptionRef subscription);